<?php
/*
=====================================================
 DataLife Engine - by SoftNews Media Group 
-----------------------------------------------------
 http://dle-news.ru/
-----------------------------------------------------
 Copyright (c) 2009 IT-Security (Asafov Sergey)
=====================================================
     
=====================================================
 : api.class.php
-----------------------------------------------------
 : API        
=====================================================
*/

@error_reporting( E_ALL ^ E_NOTICE );
@ini_set( 'display_errors', true );
@ini_set( 'html_errors', false );
@ini_set( 'error_reporting', E_ALL ^ E_NOTICE );

if( ! defined( 'DATALIFEENGINE' ) ) {
	
	define( 'DATALIFEENGINE', true );

}
if( ! defined( 'ROOT_DIR' ) ) {
	
	define( 'ROOT_DIR', substr( dirname( __FILE__ ), 0, - 11 ) );

}

if( ! defined( 'ENGINE_DIR' ) ) {
	
	define( 'ENGINE_DIR', ROOT_DIR . '/engine' );

}

if( ! class_exists( 'DLE_API' ) ) {
	
	class DLE_API {
		// DB
		var $db = FALSE;
		var $version = '0.02';
		var $dle_config = Array ();
		
		// Constructor
		function DLE_API() {
			return true;
		}
		// Take user by id
		function take_user_by_id($id) {
			$id = intval( $id );
			if( $id == 0 ) return false;
			$q = $this->db->query( "Select * from " . USERPREFIX . "_users where user_id = '$id'" );
			$row = $this->db->get_row();
			if( count( $row ) == 0 ) return false;
			else return $row;
		}
		// Take user by name
		function take_user_by_name($name) {
			$name = $this->db->safesql( $name );
			if( $name == '' ) return false;
			$q = $this->db->query( "Select * from " . USERPREFIX . "_users where name = '$name'" );
			$row = $this->db->get_row();
			if( count( $row ) == 0 ) return false;
			else return $row;
		}
		// Take user by email
		function take_user_by_email($email) {
			$email = $this->db->safesql( $email );
			if( $email == '' ) return false;
			$q = $this->db->query( "Select * from " . USERPREFIX . "_users where email = '$email'" );
			$row = $this->db->get_row();
			if( count( $row ) == 0 ) return false;
			else return $row;
		}
		// Take users by group
		function take_users_by_group($group) {
			$group = intval( $group );
			$data = array();
			if( $group == 0 ) return false;
			$q = $this->db->query( "Select * from " . USERPREFIX . "_users where user_group = '$group'" );
			while ( $row = $this->db->get_row() ) {
				$data[$row['user_id']] = $row;
			}
			if( count( $data ) == 0 ) return false;
			else return $data;
		}
		// Take users by ip
		function take_users_by_ip($ip, $like = false) {
			$ip = $this->db->safesql( $ip );
			$data = array();
			if( $ip == '' ) return false;
			if( $like ) {
				$q = $this->db->query( "Select * from " . USERPREFIX . "_users where logged_ip like '$ip%'" );
			} else {
				$q = $this->db->query( "Select * from " . USERPREFIX . "_users where logged_ip = '$ip'" );
			}
			while ( $row = $this->db->get_row() ) {
				$data[$row['user_id']] = $row;
			}
			if( count( $data ) == 0 ) return false;
			else return $data;
		}
		// Change user name
		function change_user_name($user_id, $new_name) {
			$user_id = intval( $user_id );
			$new_name = $this->db->safesql( $new_name );
			$count_arr = $this->db->get_row( $this->db->query( "Select count(user_id) as count from " . USERPREFIX . "_users where name = '$new_name'" ) );
			$count = $count_arr['count'];
			if( $count > 0 ) {
				return - 1;
			} else {
				$q = $this->db->query( "update " . USERPREFIX . "_users set name = '$new_name' where user_id = '$user_id'" );
				if( ! $q ) return 0;
				else return 1;
			}
		}
		// Change user password
		function change_user_password($user_id, $new_password) {
			$user_id = intval( $user_id );
			$new_password = md5( md5( $new_password ) );
			$q = $this->db->query( "update " . USERPREFIX . "_users set password = '$new_password' where user_id = '$user_id'" );
			if( ! $q ) return 0;
			else return 1;
		}
		// Change user email
		function change_user_email($user_id, $new_email) {
			$user_id = intval( $user_id );
			$new_email = $this->db->safesql( $new_email );
			$q = $this->db->query( "update " . USERPREFIX . "_users set email = '$new_email' where user_id = '$user_id'" );
			if( ! $q ) return 0;
			else return 1;
		}
		// Change user group
		function change_user_group($user_id, $new_group) {
			$user_id = intval( $user_id );
			$new_group = intval( $new_group );
			$q = $this->db->query( "update " . USERPREFIX . "_users set user_group = '$new_group' where user_id = '$user_id'" );
			if( ! $q ) return 0;
			else return 1;
		}
		// Check auth
		function check_auth($login, $password) {
			$login = $this->db->safesql( $login );
			$password = md5( md5( $password ) );
			$arr = $this->db->get_row( $this->db->query( "Select user_id from " . USERPREFIX . "_users where name = '$name' AND password = '$password'" ) );
			if( ! empty( $arr['user_id'] ) ) return true;
			else return false;
		}
		// External register
		function external_register($login, $password, $email, $group) {
			$login = $this->db->safesql( $login );
			$password = md5( md5( $password ) );
			$email = $this->db->safesql( $email );
			$group = intval( $group );
			$login_exist_arr = $this->db->get_row( $this->db->query( "Select count(user_id) as count from " . USERPREFIX . "_users where name = '$login'" ) );
			$email_exist_arr = $this->db->get_row( $this->db->query( "Select count(user_id) as count from " . USERPREFIX . "_users where email = '$email'" ) );
			if( $login_exist_arr['count'] > 0 ) {
				return - 1;
			} elseif( $email_exist_arr['count'] > 0 ) {
				return - 2;
			} else {
				$now = time();
				$q = $this->db->query( "insert into " . USERPREFIX . "_users (email, password, name, user_group, reg_date) VALUES ('$email', '$password', '$login', '$group', '$now')" );
				if( ! $q ) return 0;
				else return 1;
			}
		}
		// Send PM to user
		function send_pm_to_user($user_id, $subject, $text, $from) {
			$user_id = intval( $user_id );
			// Check if user exist
			$count_arr = $this->db->get_row( $this->db->query( "Select count(user_id) as count from " . USERPREFIX . "_users where user_id = '$user_id'" ) );
			$count = $count_arr['count'];
			if( $count > 0 ) {
				$subject = $this->db->safesql( $subject );
				$text = $this->db->safesql( $text );
				$from = $this->db->safesql( $from );
				$now = time();
				$q = $this->db->query( "insert into " . PREFIX . "_pm (subj, text, user, user_from, date, pm_read, folder) VALUES ('$subject', '$text', '$user_id', '$from', '$now', 'no', 'inbox')" );
				if( ! $q ) return 0;
				else {
					$this->db->query( "update " . USERPREFIX . "_users set pm_unread = pm_unread + 1, pm_all = pm_all+1 " );
					return 1;
				}
			} else {
				return - 1;
			}
		}
	}
	
	$dle_api = new DLE_API( );
	
	if( ! $config['version_id'] ) include_once (ENGINE_DIR . '/data/config.php');
	
	$dle_api->dle_config = $config;
	
	if( ! isset( $db ) ) {

		include_once (ENGINE_DIR . '/classes/mysql.php');
		include_once (ENGINE_DIR . '/data/dbconfig.php');
	
	}
	
	$dle_api->db = $db;
}

?>