<?php
/*
=====================================================
 DataLife Engine - by SoftNews Media Group 
-----------------------------------------------------
 http://dle-news.ru/
-----------------------------------------------------
 Copyright (c) 2004,2009 SoftNews Media Group
=====================================================
     
=====================================================
 : templates.class.php
-----------------------------------------------------
 :  
=====================================================
*/

class dle_template {
	
	var $dir = '.';
	var $template = null;
	var $copy_template = null;
	var $data = array ();
	var $block_data = array ();
	var $result = array ('info' => '', 'vote' => '', 'speedbar' => '', 'content' => '' );
	
	var $template_parse_time = 0;
	
	function set($name, $var) {
		if( is_array( $var ) && count( $var ) ) {
			foreach ( $var as $key => $key_var ) {
				$this->set( $key, $key_var );
			}
		} else
			$this->data[$name] = $var;
	}
	
	function set_block($name, $var) {
		if( is_array( $var ) && count( $var ) ) {
			foreach ( $var as $key => $key_var ) {
				$this->set_block( $key, $key_var );
			}
		} else
			$this->block_data[$name] = $var;
	}
	
	function load_template($tpl_name) {

		$time_before = $this->get_real_time();
		
		if( $tpl_name == '' || ! file_exists( $this->dir . DIRECTORY_SEPARATOR . $tpl_name ) ) {
			die( "  : " . $tpl_name );
			return false;
		}
		$this->template = file_get_contents( $this->dir . DIRECTORY_SEPARATOR . $tpl_name );
		
		if( strpos( $this->template, "{include file=" ) !== false ) {
			
			$this->template = preg_replace( "#\\{include file=['\"](.+?)['\"]\\}#ies", "\$this->sub_load_template('\\1')", $this->template );
		
		}

		if (strpos ( $this->template, "[not-group=" ) !== false) {
			$this->template = preg_replace ( "#\\[not-group=(.+?)\\](.*?)\\[/not-group\\]#ies", "\$this->check_group('\\1', '\\2', false)", $this->template );
		}
		
		if (strpos ( $this->template, "[group=" ) !== false) {
			$this->template = preg_replace ( "#\\[group=(.+?)\\](.*?)\\[/group\\]#ies", "\$this->check_group('\\1', '\\2')", $this->template );
		}
		
		$this->copy_template = $this->template;
		
		$this->template_parse_time += $this->get_real_time() - $time_before;
		return true;
	}
	
	function sub_load_template($tpl_name) {
		
		$tpl_name = totranslit( $tpl_name );
		
		if( $tpl_name == '' || ! file_exists( $this->dir . DIRECTORY_SEPARATOR . $tpl_name ) ) {
			die( "  : " . $tpl_name );
			return false;
		}
		$template = file_get_contents( $this->dir . DIRECTORY_SEPARATOR . $tpl_name );
		
		return $template;
	}

	function check_group($groups, $block, $action = true) {
		global $member_id;
		
		$groups = explode( ',', $groups );
		
		if( $action ) {
			
			if( ! in_array( $member_id['user_group'], $groups ) ) return "";
		
		} else {
			
			if( in_array( $member_id['user_group'], $groups ) ) return "";
		
		}
		
		$block = str_replace( '\"', '"', $block );
		
		return $block;
	
	}
	
	function _clear() {
		
		$this->data = array ();
		$this->block_data = array ();
		$this->copy_template = $this->template;
	
	}
	
	function clear() {
		
		$this->data = array ();
		$this->block_data = array ();
		$this->copy_template = null;
		$this->template = null;
	
	}
	
	function global_clear() {
		
		$this->data = array ();
		$this->block_data = array ();
		$this->result = array ();
		$this->copy_template = null;
		$this->template = null;
	
	}
	
	function compile($tpl) {
		
		$time_before = $this->get_real_time();
		
		foreach ( $this->data as $key_find => $key_replace ) {
			$find[] = $key_find;
			$replace[] = $key_replace;
		}
		
		$result = str_replace( $find, $replace, $this->copy_template );
		
		if( count( $this->block_data ) ) {
			foreach ( $this->block_data as $key_find => $key_replace ) {
				$find_preg[] = $key_find;
				$replace_preg[] = $key_replace;
			}
			
			$result = preg_replace( $find_preg, $replace_preg, $result );
		}
		
		if( isset( $this->result[$tpl] ) ) $this->result[$tpl] .= $result;
		else $this->result[$tpl] = $result;
		
		$this->_clear();
		
		$this->template_parse_time += $this->get_real_time() - $time_before;
	}
	
	function get_real_time() {
		list ( $seconds, $microSeconds ) = explode( ' ', microtime() );
		return (( float ) $seconds + ( float ) $microSeconds);
	}
}
?>