<?php

class Hot_Api_Core extends Core_Api_Abstract
{
  public function getHotsPaginator($params = array())
  {
    $paginator = Zend_Paginator::factory($this->getHotsSelect($params));
    if( !empty($params['page']) )
    {
      $paginator->setCurrentPageNumber($params['page']);
    }
    if( !empty($params['limit']) )
    {
      $paginator->setItemCountPerPage($params['limit']);
    }
    return $paginator;
  }

  public function getHotsSelect($params = array())
  {
    $table = Engine_Api::_()->getDbtable('hots', 'hot');
    $rName = $table->info('name');

    
    $select = $table->select()
      ->from($table->info('name'))
      ->order( !empty($params['orderby']) ? $params['orderby'].' DESC' : "$rName.creation_date DESC" );

      
    if( !empty($params['status']) && is_numeric($params['status']) )
    {
      $select->where($rName.'.status = ?', $params['status']);
    }
    
    //$select->where($rName.'.status = ?', 1);      
   
    if( !empty($params['owner_id']) && is_numeric($params['owner_id']) )
    {
      $select->where($rName.'.owner_id = ?', $params['owner_id']);
    }

    if( !empty($params['user']) && $params['user'] instanceof User_Model_User )
    {
      $select->where($rName.'.owner_id = ?', $params['owner_id']->getIdentity());
    }
    
    return $select;
  }

  
  public function getRating($hot_id)
  {
    $table  = Engine_Api::_()->getDbTable('ratings', 'hot');
    $rating_sum = $table->select()
      ->from($table->info('name'), new Zend_Db_Expr('SUM(rating)'))
      ->group('hot_id')
      ->where('hot_id = ?', $hot_id)
      ->query()
      ->fetchColumn(0)
      ;

    $total = $this->ratingCount($hot_id);
    if ($total) $rating = $rating_sum/$this->ratingCount($hot_id);
    else $rating = 0;
    
    return $rating;
  }

  public function getRatings($hot_id)
  {
    $table  = Engine_Api::_()->getDbTable('ratings', 'hot');
    $rName = $table->info('name');
    $select = $table->select()
                    ->from($rName)
                    ->where($rName.'.hot_id = ?', $hot_id);
    $row = $table->fetchAll($select);
    return $row;
  }
  
  public function checkRated($hot_id, $user_id)
  {
    $table  = Engine_Api::_()->getDbTable('ratings', 'hot');

    $rName = $table->info('name');
    $select = $table->select()
                 ->setIntegrityCheck(false)
                    ->where('hot_id = ?', $hot_id)
                    ->where('user_id = ?', $user_id)
                    ->limit(1);
    $row = $table->fetchAll($select);
    
    if (count($row)>0) return true;
    return false;
  }

  public function setRating($hot_id, $user_id, $rating=null){
    $table  = Engine_Api::_()->getDbTable('ratings', 'hot');
    $rName = $table->info('name');
    $select = $table->select()
                    ->from($rName)
                    ->where($rName.'.hot_id = ?', $hot_id)
                    ->where($rName.'.user_id = ?', $user_id);
    $row = $table->fetchRow($select);
    if (empty($row)) {
      // create rating
      Engine_Api::_()->getDbTable('ratings', 'hot')->insert(array(
        'hot_id' => $hot_id,
        'user_id' => $user_id,
//        'rating' => $rating
      ));
    }
/*
    $select = $table->select()
      //->setIntegrityCheck(false)
      ->from($rName)
      ->where($rName.'.hot_id = ?', $hot_id);

    $row = $table->fetchAll($select);
    $total = count($row);
    foreach( $row as $item )
    {
      $rating += $item->rating;
    }
    $hot = Engine_Api::_()->getItem('hot', $hot_id);
    $hot->rating = $rating/$total;
    $hot->save();*/
    
  }

  public function ratingCount($hot_id){
    $table  = Engine_Api::_()->getDbTable('ratings', 'hot');
    $rName = $table->info('name');
    $select = $table->select()
                    ->from($rName)
                    ->where($rName.'.hot_id = ?', $hot_id);
    $row = $table->fetchAll($select);
    $total = count($row);
    return $total;
  }


  public function deleteHot($hot)
  {

    // delete hot ratings
    Engine_Api::_()->getDbtable('ratings', 'hot')->delete(array(
      'hot_id = ?' => $hot->hot_id,
    ));

    // check to make sure the hot did not fail, if it did we wont have files to remove
    if ($hot->status == 1){
      // delete storage files (hot file and thumb)      
      if ($hot->photo_id) Engine_Api::_()->getItem('storage_file', $hot->photo_id)->remove();
    }
    
    // delete activity feed and its comments/likes
    Engine_Api::_()->getItem('hot', $hot->hot_id)->delete();
  }
  
  
  public function updateWinner()
  {
    $table  = Engine_Api::_()->getDbTable('hots', 'hot');
    $rName = $table->info('name');
    $select = $table->select()
                    ->from($rName)
                    ->where($rName.'.status = ?', 1)
                    ->order($rName.'.rate_average DESC')
                    ->limit(1);
    $winner = $table->fetchRow($select);   
    
    if (empty($winner))
    {
        return;
    }
    
    // Check if it is first day of new month
    $current_day = date("d");
    if($current_day == "01" || $current_day == 1)
    {
    
    //SAVE DATA
    $month_year = date('Y-m-1 00:00:00',time($winner->creation_date));//date('m-Y',time());
    
    $table  = Engine_Api::_()->getDbTable('winners', 'hot');
    $rName = $table->info('name');
    $select = $table->select()
                    ->from($rName)
                    ->where("winning_date = ?",$month_year )
                    ;
    $row = $table->fetchRow($select);
    
    if (empty($row)) {
      // create rating
      Engine_Api::_()->getDbTable('winners', 'hot')->insert(array(
        
        'user_id' => $winner->owner_id,
        'photo_id' => $winner->photo_id,
        'rate_count' => $winner->rate_count,
        'rate_average' => $winner->rate_average,
        'title' => $winner->title,
        'description' => $winner->description,
        'winning_date' =>$month_year
      ));
    }
    
      $db = Engine_Db_Table::getDefaultAdapter();
      $db->beginTransaction();
      try {
        $db->query("
                            UPDATE engine4_hot_hots                                 
                               SET engine4_hot_hots.status = 0, engine4_hot_hots.photo_id = null
                               
                        ");          
        $db->commit();
        
      } catch (Exception $e) {
        $db->rollback();
        throw $e;
      }          
    }
    
  }
  
  public function getWinnerSelect($params = array())
  {
    $table = Engine_Api::_()->getDbTable('winners', 'hot');
    $select = $table->select();          
    
    //download id
    if( isset($params['winner_id']) )
    {
      $select->where('winner_id = ?', $params['winner_id']);
    } 
    
    $select->order(' winning_date DESC ');
    
    // title
    if(!empty($params['title']))
    {
        $select->where('title LIKE ?', $params['title'].'%');
    }
    
    return $select;
  }

  public function getWinnerPaginator($params = array())
  {
    return Zend_Paginator::factory($this->getWinnerSelect($params));
  }
}
