<?php
/**
 * SocialEngine
 *
 * @category   Application_Extensions
 * @package    Hot
 * @copyright  Copyright 2006-2010 Webligo Developments
 * @license    http://www.socialengine.net/license/
 * @version    $Id: Level.php 6858 2010-07-27 01:16:32Z john $
 * @author     Jung
 */

/**
 * @category   Application_Extensions
 * @package    Hot
 * @copyright  Copyright 2006-2010 Webligo Developments
 * @license    http://www.socialengine.net/license/
 */
class Hot_Form_Admin_Level extends Authorization_Form_Admin_Level_Abstract
{

  protected $_public;



  public function init()
  {
    $this
      ->setTitle('Member Level Settings')
      ->setDescription('These settings are applied on a per member level basis. Start by selecting the member level you want to modify, then adjust the settings for that level below.');

    $this->loadDefaultDecorators();
    $this->getDecorator('Description')->setOptions(array('tag' => 'h4', 'placement' => 'PREPEND'));

    // prepare user levels
    $table = Engine_Api::_()->getDbtable('levels', 'authorization');
    $select = $table->select();
    $user_levels = $table->fetchAll($select);
    
    foreach ($user_levels as $user_level){
      $levels_prepared[$user_level->level_id]= $user_level->getTitle();
    }
    
    // category field
    $this->addElement('Select', 'level_id', array(
          'label' => 'Member Level',
          'multiOptions' => $levels_prepared,
          'onchange' => 'javascript:fetchLevelSettings(this.value);',
          'ignore' => true
        ));
    
   
   // Element: view
    $this->addElement('Radio', 'view', array(
      'label' => 'Allow Viewing of Rate My Pic plugin?',
      'description' => 'Do you want to let members view Rate My Pic? If set to no, some other settings on this page may not apply.',
      'multiOptions' => array(        
        1 => 'Yes, allow viewing of Rate My Pic.',
        0 => 'No, do not allow Rate My Pic to be viewed.',
      ),
       'value' => ( $this->isModerator() ? 1 : 0 ),
    ));
	

    $this->addElement('Button', 'submit', array(
      'label' => 'Save Settings',
      'type' => 'submit',
      'ignore' => true
    ));

  }
}