<div class="headline">
  <h2>
    <?php echo $this->translate('Rate My Pic');?>
  </h2>
  <div class="tabs">
    <?php
      // Render the menu
      echo $this->navigation()
        ->menu()
        ->setContainer($this->navigation)
        ->render();
    ?>
  </div>
</div>

  <div class='layout_middle'>
  	<?php if( $this->paginator->getTotalItemCount() > 0 ): ?>

    <ul class="thumbs">
      <?php foreach( $this->paginator as $hot ): ?>
        <li>
          <?php echo $this->htmlLink(array('route' => 'hot_general', 'action' => 'rating', 'hot_id' => $hot->hot_id), $this->itemPhoto($hot, 'thumb.normal'),array('class' => 'smoothbox thumbs_photo')) ?>
          <p class="thumbs_info">
            <span class="thumbs_title">
              <?php echo $this->htmlLink($hot, $this->string()->chunk(substr($hot->getTitle(), 0, 45), 10)) ?>
            </span>
            <?php echo $this->translate('By');?>
            <?php echo $this->htmlLink($hot->getOwner()->getHref(), $hot->getOwner()->getTitle(), array('class' => 'thumbs_author')) ?>
            <br />
            <?php echo $this->translate('Average rating:');?> <?php echo round($hot->rate_average,2); ?><br />
             <?php echo $this->translate('Rates:');?> <?php echo $hot->rate_count; ?><br />
          </p>
        </li>
      <?php endforeach;?>
    </ul>
  <?php else: ?>
    <div class="tip">
        <span>
          <?php echo $this->translate('Tip: %1$sClick here%2$s to create the first picture for rating!', "<a href='".$this->url(array('action' => 'upload'), 'hot_general', true)."'>", '</a>'); ?>
        </span>
      </div>
  <?php endif; ?>
  
  <?php echo $this->paginationControl($this->paginator, null, null, array(
      'query' => $this->formValues
    )); ?>
  </div>

