<?php
/**
 * SocialEngine
 *
 * @category   Application_Extensions
 * @package    Hot
 * @copyright  Copyright 2006-2010 Webligo Developments
 * @license    http://www.socialengine.net/license/
 * @version    $Id: index.tpl 7991 2010-12-08 18:17:43Z char $
 * @author     Jung
 */
?>


<script type="text/javascript">

function multiDelete()
{
  return confirm("<?php echo $this->translate("Are you sure you want to delete the selected hots?") ?>");
}

function selectAll()
{
  var i;
  var multidelete_form = $('multidelete_form');
  var inputs = multidelete_form.elements;
  for (i = 1; i < inputs.length; i++) {
    if (!inputs[i].disabled) {
      inputs[i].checked = inputs[0].checked;
    }
  }
}

 function killProcess(hot_id) {
    (new Request.JSON({
      'format': 'json',
      'url' : '<?php echo $this->url(array('module' => 'hot', 'controller' => 'admin-manage', 'action' => 'kill'), 'default', true) ?>',
      'data' : {
        'format' : 'json',
        'hot_id' : hot_id
      },
      'onRequest' : function(){
        $$('input[type=radio]').set('disabled', true);
      },
      'onSuccess' : function(responseJSON, responseText)
      {
        window.location.reload();
      }
    })).send();

  }
</script>

<h2>
  <?php echo $this->translate("Hots Plugin") ?>
</h2>

<?php if( count($this->navigation) ): ?>
  <div class='tabs'>
    <?php
      // Render the menu
      //->setUlClass()
      echo $this->navigation()->menu()->setContainer($this->navigation)->render()
    ?>
  </div>
<?php endif; ?>

<p>
  <?php echo $this->translate("List of Rate My Pic photo that user uploads. ") ?>
</p>

<br />

<?php if( count($this->paginator) ): ?>
  <form id='multidelete_form' method="post" action="<?php echo $this->url();?>" onSubmit="return multiDelete()">
  <table class='admin_table'>
    <thead>
      <tr>
        <th class='admin_table_short'><input onclick='selectAll();' type='checkbox' class='checkbox' /></th>
        <th class='admin_table_short'>ID</th>
        <th><?php echo $this->translate("Title") ?></th>
        <th><?php echo $this->translate("Owner") ?></th>
		<th><?php echo $this->translate("Photo") ?></th>
        <th><?php echo $this->translate("Rate Count") ?></th>
		<th><?php echo $this->translate("Rate Average") ?></th>        
        <th><?php echo $this->translate("Date") ?></th>
        <th><?php echo $this->translate("Options") ?></th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($this->paginator as $item): ?>
        <tr>
          <td><input type='checkbox' class='checkbox' name='delete_<?php echo $item->hot_id;?>' value='<?php echo $item->hot_id ?>' /></td>
          <td><?php echo $item->hot_id ?></td>
          <td><?php echo $item->title ?></td>
          <td><?php echo $this->user($item->owner_id)->getTitle() ?></td>
		  <td><?php
            if( $item->photo_id ) echo $this->itemPhoto($item, 'thumb.normal');
            else echo '<img height="20px" alt="" src="application/modules/Hot/externals/images/hot.png">';
          	?></td>
          <td><?php echo $this->locale()->toNumber($item->rate_count) ?></td>
		  <td><?php echo $this->locale()->toNumber($item->rate_average) ?></td>          
          <td><?php echo $this->locale()->toDateTime($item->creation_date) ?></td>
          <td>            
            <?php echo $this->htmlLink(
                array('route' => 'default', 'module' => 'hot', 'controller' => 'admin-manage', 'action' => 'delete', 'id' => $item->hot_id),
                $this->translate("delete"),
                array('class' => 'smoothbox')) ?>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

  <br />

  <div class='buttons'>
    <button type='submit'><?php echo $this->translate("Delete Selected") ?></button>
  </div>
  </form>

  <br />

  <div>
    <?php echo $this->paginationControl($this->paginator); ?>
  </div>

<?php else: ?>
  <div class="tip">
    <span>
      <?php echo $this->translate("There are no hots posted by your members yet.") ?>
    </span>
  </div>
<?php endif; ?>
