(function($) {
    $.fn.singleLineLogin = function(options) {
        debugger;
        return this.each(function() {
            var settings = {
                symbol: '\u25CF',    // symbol to replace password with            
                usernametype: 'text',    // change it to true if you want to use email address as username
                invalid_email_msg: 'Please enter valid email',  // error message that you want to show for invalid email if validate_email is true
                msg_container: null,    // error message container id if validate_email is true
                msg_class: 'error',  // css class for the invalid email message if validate_email is true
                userfield: '',
                passfield: ''

            };
            var caretPosition = 0;
            if (options) {
                $.extend(settings, options);
            }
            var usernameField;
            var passwordField;
            var submitbutton;
            if (settings.userfield != '')
                usernameField = $('#' + settings.userfield).css('display', 'none');
            if (settings.passfield != '')
                passwordField = $('#' + settings.passfield).css('display', 'none');
            if (settings.submitbutton != '')
                submitbutton = $('#' + settings.submitbutton).css('display', 'none');

            if (usernameField == null || passwordField == null) { alert('Username and password fields are required for single line login'); return; }

            var singlelinecontainer = $(this);
            var $input = $('<input/>').addClass('txt_field').attr('id', 'single-line-login').attr('value', '   ');
            singlelinecontainer.append($input);

            if (settings.msg_container == null) {
                $input.after('<label id="SingleLineLoginErrorMsg" style="display:none" class="' + settings.msg_class + '">' + settings.invalid_email_msg + '</label>');
                settings.msg_container = '#SingleLineLoginErrorMsg';
            } else {
                $(settings.msg_container).addClass(settings.msg_class).hide().html(settings.invalid_email_msg);
            }

            var methods = {
               
                validate_email: function(email) {
                    var email_pattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/;
                    return email_pattern.test(email);
                },
                formatText: function(ev, elem) {
                    var original_string = $(elem).val();

                    var decoded_string = $input.val();
                    var plain_text = '';
                    var space_index = original_string.indexOf(' ');


                    if (decoded_string != '') {
                        var username = '';
                        var pass = '';
                        if (space_index == -1) {
                            plain_text = original_string;
                            username = plain_text;
                            pass = '';

                        } else {

                            username = original_string.slice(0, original_string.indexOf(' '));
                            var ps = original_string.slice(original_string.indexOf(' ') + 1);
                            var dps = decoded_string.slice(decoded_string.indexOf(' ') + 1);

                            var found = false;
                            var pslength = ps.length;
                            var dpslength = dps.length;

                            for (var i = 0; i < pslength; i++) {

                                if (found == true && pslength > dpslength) { // to handle the insertioin in the middle or beginning

                                    pass += dps.charAt(i - 1);

                                } else {

                                    if (ps.charAt(i) == settings.symbol) {
                                        pass += dps.charAt(i);
                                    } else {
                                        pass += ps.charAt(i);
                                        found = true;
                                    }
                                }
                            }

                            plain_text = username + ' ' + pass;
                        }

                    } else {
                        plain_text = original_string;
                        if (space_index == -1) {
                            username = original_string;
                            pass = '';
                        } else {
                            username = original_string.slice(0, space_index);
                            pass = original_string.slice(space_index + 1);
                        }
                    }

                    $input.val(plain_text);

                    if (space_index == -1) {
                        $(elem).val(username);
                    } else {
                        $(elem).val(username + ' ' + pass);
                    }


                    usernameField.val(username);
                    passwordField.val(pass);
                    if (space_index >= 0 && settings.usernametype == 'email' && methods.validate_email(username) != true) {
                        $(settings.msg_container).show();  // show error message
                    } else if (space_index >= 0 && settings.usernametype == 'email') {
                        $(settings.msg_container).hide(); // hide error message
                    }
                }
            }

            function getCaret(el) {
                if (el.selectionStart) {
                    return el.selectionStart;
                } else if (document.selection) {
                    el.focus();

                    var r = document.selection.createRange();
                    if (r == null) {
                        return 0;
                    }

                    var re = el.createTextRange(),
        rc = re.duplicate();
                    re.moveToBookmark(r.getBookmark());
                    rc.setEndPoint('EndToStart', re);

                    return rc.text.length;
                }
                return 0;
            }
            function setCaretTo(obj, pos) {
                if (obj.createTextRange) {
                    var range = obj.createTextRange();
                    range.move("character", pos);
                    range.select();
                } else if (obj.selectionStart) {
                    obj.focus();
                    obj.setSelectionRange(pos, pos);
                }
            }
            $input
				.bind('input', function(ev) {
				    methods.formatText(ev, this);
				    if (caretPosition > 0) {
				        caretPosition++;
				        setCaretTo(this, caretPosition);
				    }
				}) 
            				.keyup(function(ev) {
            				    // methods.formatText(ev, this);
            				    caretPosition = getCaret(this);
            				})
        });
    };
})(jQuery);